// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Traied Nagios.cpp                                                                                          ==
// ==                 =================                                                                                          ==
// ==          Zweck: Hauptdatei des Projekts Traied Nagios                                                                      ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#include "../include/Traied Nagios.h"

// ================================================================================================================================
// Die Hauptfunktion
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, char* pcCmdLine, int iShowCmd)
{
	// Wir initialisieren die Hauptklasse, starten die Hauptschleife und beenden dann alles wieder
	if(TN_MAIN.Init(hInstance)) return FALSE;
	TN_MAIN.MainLoop();
	if(TN_MAIN.Exit()) return FALSE;

	// Alles OK!
	return TRUE;
}

// ================================================================================================================================
// Die Singletonmethode
CTraiedNagios& CTraiedNagios::GetInstance()
{
	// Die einzige Instanz zurckgeben
	static CTraiedNagios TheOne;
	return TheOne;
}

// ================================================================================================================================
// Initialisiert
EResult CTraiedNagios::Init(HINSTANCE hInstance)
{
	// Damit die Instanz mehrmals genutzt werden kann
	Exit();

	// Wir speichern die Instanz
	m_hInstance = hInstance;

	// Speicher fr Klassen / Strukturen reservieren
	m_pGUI		= new CGUI;
	m_pConfig	= new SConfig;

	// Wir initialisieren die Netzwerkklasse
	m_pNetwork = new CNetwork;
	if(m_pNetwork->Init())
		return ER_ERROR;	// Fehler!

	// Die Konfiguration laden
	ZeroMemory(m_pConfig, sizeof(SConfig));
	if(LoadConfig(m_pConfig) != ER_OK)
	{
		// Fehler! Das heit wir mssen den Dialog starten
		m_pConfig->wConfigVersion		= 1;
		m_pConfig->bCheckAutomatically  = TRUE;
		m_pConfig->dwCheckInterval		= 45;
		m_pConfig->bAuthRequired		= FALSE;
		strcpy(m_pConfig->acNagiosUrl,	  TN_DEFINITION_SERVER);
		strcpy(m_pConfig->acNagiosCgiUrl, TN_DEFINITION_SERVER_CGI);
		m_pConfig->abAlertPopups[0]		= TRUE;
		m_pConfig->abAlertPopups[1]		= TRUE;
		m_pConfig->abAlertPopups[2]		= TRUE;
		m_pConfig->abAlertPopups[3]		= TRUE;

		m_pConfig->abAlertSounds[0]		= TRUE;
		m_pConfig->abAlertSounds[2]		= TRUE;
		m_pConfig->abAlertSounds[3]		= TRUE;

		strcpy(m_pConfig->acLanguage, "");

		m_pConfig->bVersionCheck		= TRUE;
		DoConfigDlg(m_pConfig);
	}
	else	// Sollen Sounds ausgegeben werden? Wir prfen mit else,
	{		// weil wenn die Konfiguration erst erstellt wurde, kam die Nachricht dort
		// Ja
		BOOL bFileError = FALSE;
		if(m_pConfig->abAlertSounds[0])
		{
			FILE* pFile = fopen("OK.wav", "r");
			if(!pFile) bFileError = TRUE;
			else fclose(pFile);
		}

		if(m_pConfig->abAlertSounds[1])
		{
			FILE* pFile = fopen("Unknown.wav", "r");
			if(!pFile) bFileError = TRUE;
			else fclose(pFile);
		}

		if(m_pConfig->abAlertSounds[2])
		{
			FILE* pFile = fopen("Warning.wav", "r");
			if(!pFile) bFileError = TRUE;
			else fclose(pFile);
		}

		if(m_pConfig->abAlertSounds[3])
		{
			FILE* pFile = fopen("Alert.wav", "r");
			if(!pFile) bFileError = TRUE;
			else fclose(pFile);
		}

		// Ausgabe
		if(bFileError)
			MessageBox(NULL, GetString(IDS_SOUNDSMISSING), GetString(IDS_HINWEIS), MB_OK | MB_ICONEXCLAMATION);
	}

	// Wir starten die GUI
	if(m_pGUI->Init(hInstance))
		return ER_ERROR;	// Fehler!
	
	// Sollen wir automatisch prfen?
	if(m_pConfig->bCheckAutomatically)
	{
		// Ja, wir starten den Timer und prfen jetzt
		SetTimer(m_pGUI->GetMainWindow(), 2, m_pConfig->dwCheckInterval * 1000, NULL);
		Check();
	}

	// Sollen wir nach Updates prfen?
	if(m_pConfig->bVersionCheck)
		CheckForUpdates();

	// Alles OK!
	m_bInitialized = TRUE;
	return ER_OK;
}

// ================================================================================================================================
// Prft, ob alles ok ist
EResult CTraiedNagios::Check(BOOL bOut)
{
	char acTemp[512];
	char acAuthorization[384];

	// Wir speichern die Ausgabe. Dies tun wir bevor wir prfen, ob wir bereits abfragen
	m_bMessageOut = bOut;

	// Prfen wir bereits?
	if(m_bIsChecking) return ER_OK;
	m_bIsChecking = TRUE;	// Jetzt prfen wir

	// Wir initialisieren den Socket
	if(m_pNetwork->Start(m_pConfig->acNagiosCgiUrl) != ER_OK)
	{
		// Fehler!
		m_bIsChecking = FALSE;
		return ER_ERROR;
	}

	// Brauchen wir eine Authorisation?
	if(m_pConfig->bAuthRequired)
	{
		sprintf(acTemp, "%s:%s", m_pConfig->acAuthName, m_pConfig->acAuthPassword);
		sprintf(acAuthorization, "Authorization: Basic %s\n\n", Base64(acTemp));
	}

	// Wir senden die Nachricht
	ER_INFO(GetString(IDS_GETSTATUSTIP));
	sprintf(acTemp, "GET %s%s%s HTTP/1.0\n"
					"Connection: close\n"
					"User-agent: Traied Nagios\n"
					"Accept: text/html, text/*, */*\n"
					"%s", m_pConfig->acNagiosCgiUrl, m_pConfig->acNagiosCgiUrl[strlen(m_pConfig->acNagiosCgiUrl)-1] == '/' ? "" : "/", "statuswml.cgi?style=userstats", m_pConfig->bAuthRequired ? acAuthorization : "\n\n");
	int iResult = send(m_pNetwork->GetSocket(), acTemp, 512, 0);
	if(iResult == SOCKET_ERROR || iResult == 0)
	{
		// Fehler
		ER_ERROR(GetString(IDS_SENDERROR));
		m_pNetwork->End();
		m_bIsChecking = FALSE;
		return ER_ERROR;
	}

	// Wir starten den Timout-Timer
	SetTimer(m_pGUI->GetMainWindow(), 1, 10000, NULL);

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Prft, ob alles ok ist (Teil 2)
EResult CTraiedNagios::Check2()
{
	char acBuffer[2048];

	// Wir lschen den Timer, denn einen Timeout kann es nun nicht mehr geben
	KillTimer(m_pGUI->GetMainWindow(), 1);

	// Sind wir berhaupt noch verbunden?
	if(m_pNetwork->IsConnected())
	{
		// Ja, Empfangen
		if(recv(m_pNetwork->GetSocket(), acBuffer, 2048, 0) == SOCKET_ERROR)
		{
			// Fehler
			m_pNetwork->End();
			ER_ERROR(GetString(IDS_ERRORRECEIVE));
			m_bIsChecking = FALSE;
			return ER_ERROR;
		}

		// Verbindung schlieen
		m_pNetwork->End();

		// Alles OK! Wir rufen die Parsefunktion auf
		return Parse(acBuffer);
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Wertet die HTTP-Rckgabe aus
EResult CTraiedNagios::Parse(char* pcResponse)
{
	char	acTemp[384];
	char*	pcTemp;
	int		iHostsUp, iHostsDown, iHostsUnreachable, iHostsPending;
	int		iServicesUp, iServicesWarning, iServicesUnknown, iServicesCritical, iServicesPending;
	int		iCursor;

	// Jetzt kann man wieder prfen
	m_bIsChecking = FALSE;

	// ==========================================
	// Wir suchen nach einem Fehler
	// Auswerten
	memcpy(acTemp, pcResponse, 256);

	// Wir wollen nur die erste Zeile beginnend ab dem Statuscode
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, '\n'))-1] = '\0';
	pcTemp = &acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))+1];

	// Haben wir einen Fehler?
	if(strcmp(pcTemp, "200 OK") != 0)
	{
		// Ja, Fehler!
		// Ist es eventuell 401 Authorization Required?
		if(strcmp(pcTemp, "401 Authorization Required") == 0)
		{
			// Ja, wir sagen dem Benutzer, dass ein Passwort bentigt wird
			ER_ERROR(GetString(IDS_PASSWORDNEEDED));
		}
		else
		{
			// Ausgabe
			char* pcTemp2 = new char[256];
			strcpy(pcTemp2, pcTemp);

			sprintf(acTemp, GetString(IDS_HTTPERROR), pcTemp2);
			ER_ERROR(acTemp);
		}
		return ER_ERROR;
	}

	// ==========================================
	// Wir suchen den eigentlichen Code, den wir haben mchten
	iCursor = strlen(pcResponse) - strlen(strstr(pcResponse, "<b>Host Totals</b>"))+1;

	// Wir sind jetzt am Anfang des eigentlichen
	// HOSTS - UP
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iHostsUp = atoi(acTemp);

	// HOSTS - DOWN
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iHostsDown = atoi(acTemp);

	// HOSTS - UNREACHABLE
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iHostsUnreachable = atoi(acTemp);

	// HOSTS - PENDING
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iHostsPending = atoi(acTemp);

	// ==========================================
	// Jetzt kommen die Services
	iCursor = strlen(pcResponse) - strlen(strstr(pcResponse, "<b>Service Totals:</b>"))+1;

	// Wir sind jetzt am Anfang des eigentlichen
	// SERVICES - UP
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iServicesUp = atoi(acTemp);

	// SERVICES - WARNING
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iServicesWarning = atoi(acTemp);

	// SERVICES - UNKNOWN
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iServicesUnknown = atoi(acTemp);

	// SERVICES - CRITICAL
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iServicesCritical = atoi(acTemp);

	// SERVICES - PENDING
	iCursor += strlen(&pcResponse[iCursor]) - strlen(strchr(&pcResponse[iCursor], '\n')+1);
	memcpy(acTemp, &pcResponse[iCursor], 256);
	acTemp[strlen(acTemp) - strlen(strchr(acTemp, ' '))] = '\0';
	iServicesPending = atoi(acTemp);

	// In die Liste eintragen, zuerst die Hosts
	SendMessage(m_pGUI->GetHostWindow(), LB_RESETCONTENT, 0, 0);
	sprintf(acTemp, "Hosts insgesamt: %d", iHostsUp + iHostsDown + iHostsUnreachable + iHostsPending);
	SendMessage(m_pGUI->GetHostWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Up", iHostsUp);
	SendMessage(m_pGUI->GetHostWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Down", iHostsDown);
	SendMessage(m_pGUI->GetHostWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Unreachable", iHostsUnreachable);
	SendMessage(m_pGUI->GetHostWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Pending", iHostsPending);
	SendMessage(m_pGUI->GetHostWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	// Dann die Services
	SendMessage(m_pGUI->GetServiceWindow(), LB_RESETCONTENT, 0, 0);
	sprintf(acTemp, "Services insgesamt: %d", iServicesUp + iServicesWarning + iServicesUnknown + iServicesCritical + iServicesPending);
	SendMessage(m_pGUI->GetServiceWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Up", iServicesUp);
	SendMessage(m_pGUI->GetServiceWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Warning", iServicesWarning);
	SendMessage(m_pGUI->GetServiceWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Unknown", iServicesUnknown);
	SendMessage(m_pGUI->GetServiceWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Critical", iServicesCritical);
	SendMessage(m_pGUI->GetServiceWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	sprintf(acTemp, "%d Pending", iServicesPending);
	SendMessage(m_pGUI->GetServiceWindow(), LB_ADDSTRING, 0, (LPARAM)acTemp);

	// Debug-Warnung /- Fehler?
	if(m_bDebugOK || m_bDebugUnknown || m_bDebugWarning || m_bDebugError)
	{
		iHostsUp = 1;
		iServicesUp = 1;
		iHostsDown = 0;
		iHostsUnreachable = 0;
		iServicesCritical = 0;
		iServicesWarning = 0;
		iServicesUnknown = 0;
		iHostsPending = 0;
		iServicesPending = 0;
	}
	if(m_bDebugUnknown)	iServicesPending++;
	if(m_bDebugWarning)	iServicesWarning++;
	if(m_bDebugError)	iServicesCritical++;
	m_bDebugError = m_bDebugWarning = m_bDebugUnknown = m_bDebugOK = FALSE;

	// Alles OK?
	if(iHostsDown != 0 || iHostsUnreachable != 0 || iServicesCritical != 0)
	{
		// Nein!
		// Kommandozeile?
		if(m_pConfig->abAlertCommands[3] && m_iLastStatus != 3)
		{
			// Ausfhren
			CallCommandLine(m_pConfig->acAlertCommand[3]);
		}
		
		// Ausgabe, dann mssen wir das Icon wechseln und das Fenster ffnen
		sprintf(acTemp, GetString(IDS_ERRORTEXT), iHostsDown, iHostsUnreachable, iServicesCritical);
		ER_ERROR(acTemp);
	}
	else if(iServicesWarning != 0)
	{
		// Warnung!
		// Kommandozeile?
		if(m_pConfig->abAlertCommands[2] && m_iLastStatus != 2)
		{
			// Ausfhren
			CallCommandLine(m_pConfig->acAlertCommand[2]);
		}

		// Warnung
		sprintf(acTemp, GetString(IDS_WARNINGTEXT), iServicesWarning);
		ER_WARNING(acTemp);
	}
	else if(iHostsPending != 0 || iServicesPending != 0 || iServicesUnknown != 0)
	{
		// Kommandozeile?
		if(m_pConfig->abAlertCommands[1] && m_iLastStatus != 1)
		{
			// Ausfhren
			CallCommandLine(m_pConfig->acAlertCommand[1]);
		}

		// Pending: also unbekannt
		sprintf(acTemp, GetString(IDS_UNKNOWNTEXT), iServicesUnknown, iServicesPending, iHostsPending);
		ER_UNKNOWN(acTemp);
	}
	else
	{
		// Kommandozeile?
		if(m_pConfig->abAlertCommands[0] && m_iLastStatus != 0)
		{
			// Ausfhren
			CallCommandLine(m_pConfig->acAlertCommand[0]);
		}

		// Alles ist OK!
		ER_OK(GetString(IDS_STATUSOK));
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Die Hauptschleife
EResult CTraiedNagios::MainLoop()
{
	// Wir starten die Fensterschleife
	return m_pGUI->MainLoop();
}

// ================================================================================================================================
// Deinitialisiert
EResult CTraiedNagios::Exit()
{
	// Mssen wir berhaupt etwas machen?
	if(m_bInitialized)
	{
		// Ja
		// Sollen wir nach Updates prfen?
		if(m_pConfig->bVersionCheck)
			CheckForUpdates();

		// Wir beenden die GUI
		m_pGUI->Exit();

		// Wir deaktivieren die Netzwerkklasse
		m_pNetwork->Exit();

		// Wir speichern noch einmal die Konfiguration
		SaveConfig(m_pConfig);

		// Wir sind jetzt deinitialisiert
		m_bInitialized = FALSE;
	}

	// Alles OK!
	return ER_OK;
}